/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.bits;

import emulator.hardware.bits.SharedBit;

public class SerialBit
extends SharedBit {
    private SharedBit inport;
    private boolean bus_bit;

    public SerialBit(SharedBit inport) {
        this.inport = inport;
        super.setValue(false);
        this.bus_bit = true;
        this.updateOutput();
    }

    @Override
    public synchronized boolean getValue() {
        return super.getValue();
    }

    @Override
    public synchronized void setValue(boolean value) {
        super.setValue(value);
        this.updateOutput();
    }

    @Override
    public synchronized void toggle() {
        super.toggle();
        this.updateOutput();
    }

    private void updateOutput() {
        this.inport.setValue(!super.getValue() && this.bus_bit);
    }

    public boolean getInBit() {
        return this.inport.getValue();
    }

    public void setBusBit(boolean value) {
        this.bus_bit = value;
        this.updateOutput();
    }
}

